#ifndef IPHYSICSCONTROLLER_H_
#define IPHYSICSCONTROLLER_H_

#include "../DataTypes/DataBody.h"
#include "../DataTypes/DataJoint.h"
#include "IPhysicalBody.h"
#include "IPhysicalBox.h"
#include "IPhysicalSphere.h"
#include "IPhysicalWheelCylinder.h"
#include "IPhysicalCylinder.h"
#include "IPhysicalJoint.h"
#include "../Configuration/ConfigurationServer.h"
#include "MaterialManager.h"
using namespace Configuration;
using namespace DataTypes;
namespace PhysicsEngine
{

class IPhysicsController
{
public:
	IPhysicsController();
	virtual ~IPhysicsController();
	virtual void InitWorld() = 0;
	virtual void ResetWorld() = 0;
	virtual void FreeResources() = 0;
	virtual void StepWorld(float timestep, int steps, bool fastmode)=0;
	virtual IPhysicalBody* CreatePhysicalBody(int entityid, DataBody *data)=0;
	virtual IPhysicalJoint* CreatePhysicalJoint(DataJoint *data, IPhysicalBody *body1, IPhysicalBody *body2)=0;
	virtual void SetWorldHardness(float hardness)=0;
	virtual void SetWorldBounciness(float bounciness)=0;
	virtual void SetWorldGravity(float gravx, float gravy, float gravz)=0;
	virtual string GetDrawData()=0;
	virtual map<int, IPhysicalBody *> GetBodies()=0; 
};

}

#endif /*IPHYSICSCONTROLLER_H_*/
